function [words, MFs, Cs, Cls, Crs]=getFOUsC6()

%
% [words, MFs, Cs, Cls, Crs]=getFOUsC6()
%
% To compute the 32 word FOUs from interval survey data (datacopy.xls)
% using the Interval Approach.
%
% Dongrui Wu (dongruiw@usc.edu), 4/19/2009
%
% words: names of the 32 words
% MFs: MFs of the 32 words, each described by 9 parameters (see Fig. 1 in
% Readme.doc)
% Cs: centers of centroids of the 32 words
% Cls: left-bounds of the centroids
% Crs: right-bounds of the centroids

%% Read Data
A = xlsread('datacopy.xls');
[row, col] = size(A);

%% Names of the 32 words
MFs=zeros(col/2,9);
words=[
    '          Little          ';
    '         Sizeable         ';
    '        Large (LA)        ';
    '     Quite A Bit (QAB)    ';
    '         Low Amount       ';
    '     Somewhat Small (SS)  ';
    '        A Smidgen         ';
    'None to Very Little (NVL) ';
    '     Humongous Amount     ';
    '        Huge Amount       ';
    '        Very Small        ';
    '        Very Large        ';
    '        Fair Amount       ';
    '    Modest Amount (MOA)   ';
    '       Very Little        ';
    '   Moderate Amount (MRA)  ';
    '           Medium         ';
    '     Good Amount (GA)     ';
    '      Extreme Amount      ';
    '       Teeny-Weeny        ';
    ' Considerable Amount (CA) ';
    '         A Lot (AL)       ';
    '         A Bit (AB)       ';
    '      Very Sizeable       ';
    '     Some to Moderate     ';
    '        High Amount       ';
    '           Small          ';
    '   Maximum Amount (MAA)   ';
    '         Some (S)         ';
    '          Tiny            ';
    '     Very High Amount     ';
    '    Substantial Amount    '];

%%  Compute the FOUs and centroids
for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    if i==11
        MFs(i,:) = IA(L,R,1); %% Specify Very Small to be a left-shoulder
    else
        MFs(i,:) = IA(L,R); %% Map into an IT2 FS
    end
    [Cs(i),Cls(i),Crs(i)]=centroidIT2(MFs(i,:)); %% Compute the centroid
end

%% Sort the MFs in ascending order according to the centers of centroids
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
Cs=round(Cs*100)/100;
Cls=round(100*Cls(index))/100;
Crs=round(100*Crs(index))/100;
MFs=round(100*MFs(index,:))/100;     % Reorder the MFs
words=words(index,:); % Reorder the names of words
